param([Int32]$topN=5)

$currentUTCdate = ((Get-Date).ToUniversalTime().ToString("yyyy-MM-dd HH:mm:ss"))
Write-Output "For help, see data on top 5 CPU consuming processes as of  $currentUTCdate UTC :"

function round($value) { [Decimal]::Round($value, 2) }
$Path=@{ Name="Path"; Expression={(get-process $_.Name)[0].Path} }
$GroupPCpu=@{ Name="%CPU"; Expression={round((($_.Group | measure-object CookedValue -sum).sum / $env:NUMBER_OF_PROCESSORS))} }

write-Host Top $topN CPU Processes:

(get-counter "\Process(*)\% Processor Time" -ErrorAction SilentlyContinue).CounterSamples | ? {$_.InstanceName -notmatch "_total|idle"} |
group-Object InstanceName | Select Name, $GroupPCpu, $Path | sort %CPU -desc | select -f $topN | ft -a | out-string -width 200
Write-Output "More info about collecting data https://bitbucket.wolterskluwer.io/projects/OI/repos/zabbix/browse/agent/windows/scripts/get_topN_cpu_processes.ps1"