@echo off
set COUNTER=1
( (type %1 | findstr ToBeRestarted >nul) || (sc query "Zabbix Agent" | findstr STATE | findstr /v RUNNING) ) ^
&&(
  echo %date% %time%: [INFO] Either ZabbixAgent is not in 'RUNNING' state or RestartFlag is set to 'ToBeRestarted', attempting to stop Zabbix Agent: >%2
  sc stop "Zabbix Agent" >>%2
:START
  echo %date% %time%: [INFO] Attempting to start Zabbix Agent, try #%COUNTER%: >>%2
  sc start "Zabbix Agent" >>%2
  (
    sc query "Zabbix Agent" | findstr STATE | findstr RUNNING ^
    && (
      echo %date% %time%: [INFO] Zabbix Agent started successfully, resetting RestartFlag.
      echo Restarted At %date% %time% >%1
    ) ^
    || (
      set /A COUNTER=COUNTER+1
      if "%COUNTER%"=="5" (
          echo %date% %time%: [ERROR] Last try - #%COUNTER% failed, agent service is not responding. Please check the service configuration.
          powershell -c "get-service -name 'Zabbix Agent' | fl *"
          EXIT 
      )
      if "%COUNTER%"=="3" (
        echo %date% %time%: [WARNING] Try #%COUNTER% failed, removing all files from %3 and starting the agent.
        del /q %3\*
      )
      timeout 10 >nul
      GOTO :START
    )
  ) >>%2
) ^
|| (
  echo  Nothing to do.
)